% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                        %
% METODO DE DISPARO APLICADO AL PROBLEMA DE LA CATENARIA                 %
%                                                                        %
% Consideramos el caso de una catenaria de densidad de peso por          %
% unidad de longitud rho  suspendida con diferencia de altura dh de      %
% dos postes separados una distancia L.                                  %
%                                                                        %
% Para ello, integramos mediante una rutina de integracion de ODEs       %
% con CI la ecuacion de la catenaria para varios valores de la derivada  %
% en el punto x=0.                                                       %
%                                                                        %
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


clear; clc;  % limpieza del espacio de trabajo

% PARAMETROS FISICOS DE ENTRADA
%
% h     altura de los postes (los tomamos como cero, colocando
%       adecuadamente el sistema de referencia).
%
% L     separacion horizontal entre los puntos de los que pende 
%       la catenaria
%
% rho   densidad de masa por unidad de longitud de la cuerda multiplicada
%       por la aceleracion de la gravedad
%
% Th    componente horizontal de la tension en los puntos de suspension
%
% (xa, ya) (xb, yb) coordenadas de los puntos de suspension

dh = 0.0;
L = 10.0; 
rho = 20.0;
Th   = 50.0;

xa = 0.0;
xb = L;
ya = 0.0;
yb = dh;

% PARAMETROS PARA LA EXPLORACION NUMERICA
%
% Como valor inicial ponemos 45º (por poner algo...)

sini = tan( -45.0*pi/180.0 );
nx = 21; 
            
% METODO DE DISPARO
%
% Realizamos varias integraciones del problema de condiciones iniciales
% definido por la ecuacion de la catenaria con CI y(0) = 0, y'(0)=s.
%
% Para la ingracion del problema de CI utilizamos la rutina ode45 de 
% matlab. Esta rutina requiere como argumento una función que le 
% proporcione las derivadas de las variables. En el caso de la funcion
% eccatenaria, sobra el parametro C, de modo que definimos una funcion
% fcat auxiliar para eliminarlo.
%
% fcat: funcion anonima auxiliar para pasar la ecuacion diferencial de la 
%       catenaria (definida en su propio fichero) como argumento a ode45. 
%
% Los valores de las coordenadas horizontales en los que queremos solucion
% los elegimos equiespaciados.
%
% El valor de la derivada en x=0 para el cual se satisfacen ambas 
% condiciones de contorno lo hallamos mediante la funcion fzero para
% calculo de ceros de funciones.
%
% Una vez hallado el valor de y'(xa), llamamos a ode45 para que halle 
% la funcion y para todos los valores de x.

fcat = @(x,y) eccatenaria(rho/Th, y);
x = linspace( xa, xb, nx );
fdes = @(s) desviacion( fcat, x, [ya; s], yb );

[s0, yend, exitflag, output] = fzero( fdes, sini);
fprintf('s0 = %g, yend = %g, exitflag %d\n', s0, yend, exitflag);
fprintf('s0 en grados %f\n', atan( s0 )*180.0/pi);

y0 = [ ya; s0 ];
[xs, ys] = ode45( fcat, x, y0);
    
% Dibujamos la solucion y(x).
% Destacamos el valor y(x=L) con un marcador rojo.
% Anotamos el valor del angulo al que corresponde.

figure(3); clf;
plot(xs, ys(:,1),'-',xs(nx),ys(nx,1),'or');
leyenda = sprintf('%fº', atan(s0)*180.0/pi );
text( xs(nx),ys(nx,1),leyenda);
hold on;
    

grid;

%